import { IParam, ListViewProps, ListViewState } from "@core";
import { MDView } from "../md-view";

/**
 * @description 列表视图
 * @export
 * @class ListView
 * @extends {MDView}
 */
export class ListView extends MDView {

    /**
     * 实体列表视图状态
     *
     * @type {ListViewState}
     * @memberof ListView
     */
    public declare state: ListViewState;

    /**
     * 实体列表视图输入参数
     *
     * @type {ListViewProps}
     * @memberof ListView
     */
    public declare props: ListViewProps;

    /**
     * @description 列表部件
     * @type {IParam}
     * @memberof ListView
     */
    public declare list: IParam;

    /**
     * @description 处理视图初始化
     * @memberof ListView
     */
    public useViewInit(): void {
        super.useViewInit();
        this.list = ref(null);
    }

    /**
     * @description 获取多数据部件
     * @return {*} 
     * @memberof ListView
     */
    public getMDCtrl() {
        return unref(this.list);
    }

    /**
     * @description 安装视图所有功能模块的方法
     * @return {*} 
     * @memberof ListView
     */
    public moduleInstall() {
        const superParams = super.moduleInstall();
        return {
            ...superParams,
            list: this.list
        };
    }
}